package tests;

/**
 * This interface represents any properly tunable irrigator: the tuning is
 * realized by giving a percent value to the irrigator itself
 * 
 * @author simone
 * @since 1.0
 * @version 1.0
 * @see OnOffIrrigator
 *
 */
public interface TunableIrrigator {

	/**
	 * Set a percent value of the complete power available. A null value will
	 * result in a turning off for the irrigator
	 * 
	 * @param percentValue
	 *            : the percent value
	 */
	void set(int percentValue);
}
